/// Section Begin  - kadov DHTM (JavaScript 1.2)
// eHelp Corporation Dynamic HTML JavaScript 
// Copyright 1998-2000 eHelp Corporation.All rights reserved.
// Version=4.45

// Warning:Do not modify this file.It is generated by RoboHELP and changes will be overwritten.



//Begin to support extended and dropdown text effects.
function kadovIsParagraph(el)
{
	return( el.tagName == "P" || el.tagName.indexOf("H") == 0 ) ? true : false;
}

function kadovInitEachChild(el)
{	
	for(var i=0; i<el.children.length; i++)
	{
		var child = el.children[i];
		if( child.tagName == "SCRIPT" || child.tagName == "!" )
			continue;

		if( child.id != "" )
		{
			// to wipe out the onload effects
			var onLoadEffect = child.style.getAttribute( "x-on-pageload" );
			if( (onLoadEffect != null) && (onLoadEffect > "") )
				child.style.setAttribute( "x-on-pageload", "" );
			
			var href = child.getAttribute("href")
			if( href != null && href > "" && href.indexOf( "BSSCPopup" ) >= 0 )
				kadovFilePopupInit(child.id); // Init for Popup
			else if( child.className == "dropspot" || child.className == "expandspot" || 
					 child.className == "glossterm" )
				kadovTextPopupInit(child.id);// Init for Expanding/Glossary or DropDown text
			else if( child.className == "trigger")
				kadovInitTrigger(child.id);// Init for Trigger
			else
			{
				kadovInitEffects(child.id);// Init for DHTML effects
				CEngine.SetOneTargetInitialState( child.id );
			}
		}
		
		if( (child.tagName == "IMG") && (child.getAttribute("dynsrc") > "") )
			child.start = "mouseover";// to start a AVI file. fileopen doesn't work

		kadovInitEachChild(child);
	}
}

function kadovRetrieveTextInner(el)
{	
	var x = "";
	if( (!el) || (el.tagName == "!") || (el.tagName == "SCRIPT" ))
		return x;

	if( kadovIsParagraph(el) )
	{
		var strNewID = " ";
		if( el.id != "" )
			strNewID += "id=" + el.id + "_NewSpan ";
		x = "<span" + strNewID + "style='" + el.style.cssText + "'>" + el.innerHTML + "</span>";
	}
	else
	{
		for(var i=0; i<el.children.length; i++)
			x += kadovRetrieveTextInner( el.children[i] );
	}
	return x;
}

function kadovRetrieveCleanHTML( strRawHTML, strTagOpen, strTagClose, nDistance )
{	
	var nTagOpen = strRawHTML.indexOf( strTagOpen, 0 );
	if( nTagOpen < 0 )
		return strRawHTML;

	var nTagClose = strRawHTML.indexOf( strTagClose, nTagOpen);
	if( nTagClose < nTagOpen )
		return strRawHTML;
		
	if( typeof(nDistance) == "number" && nDistance > 0 )
		if( (nTagClose - nTagOpen) != nDistance )
			return strRawHTML;
		
	var strCleanOnce = strRawHTML.substring(0, nTagOpen) + strRawHTML.substr(nTagClose + strTagClose.length) ;
	return 	kadovRetrieveCleanHTML( strCleanOnce, strTagOpen, strTagClose );
}

function kadovAdjustObjectTag(strRawHTML, nStartPos)
{// adjust object tag for related topics HTML control, because innerHTML misses out the item settings
	
	//Is there any DTC?
	var strDTCTagOpen = '<!--Metadata type="DesignerControl" startspan';
	var strDTCTagClose = '<!--Metadata type="DesignerControl" endspan-->';
	var nDTCTagOpen = strRawHTML.indexOf( strDTCTagOpen, nStartPos );
	if( nDTCTagOpen < 0 )
		return strRawHTML;
	var nDTCTagClose = strRawHTML.indexOf( strDTCTagClose, nDTCTagOpen );
	if( nDTCTagClose < nDTCTagOpen)
		return strRawHTML; // no Design Time Controls;
		
	//Is the DTC HTML Help Control?
	var strRTObjTagOpen = 'classid=clsid:ADB880A6-D8FF-11CF-9377-00AA003B7A11';
	var strRTObjTagClose = '</OBJECT>';
	var nRTObjTagOpen = strRawHTML.indexOf( strRTObjTagOpen, nDTCTagOpen );
	if( nRTObjTagOpen < nDTCTagOpen )
		return strRawHTML;
	var nRTObjTagClose = strRawHTML.indexOf( strRTObjTagClose, nRTObjTagOpen );
	if( nRTObjTagClose < nRTObjTagOpen )
		return strRawHTML; // is not a HTML help control
		
	// Is it a related Topics html help control?
	var strRTObjLabel = '<PARAM NAME=\"Command\" VALUE=\"Related Topics';
	if( strRawHTML.indexOf(strRTObjLabel, nRTObjTagOpen) < 0 )
		return strRawHTML;
	
	// does the commented object tag contain a items parameters		
	var strRTItemsOpen = '<param name=Items value="';
	var strRTItemsClose = '$$**$$" >';
	var nRTItemsOpen = strRawHTML.indexOf(strRTItemsOpen, nDTCTagOpen);
	if( nRTItemsOpen < nDTCTagOpen )
		return strRawHTML;
	var nRTItemsClose = strRawHTML.indexOf(strRTItemsClose, nRTItemsOpen);
	if( nRTItemsClose < nRTItemsOpen )
		return strRawHTML;
		
	// found a items string
	var strItems = strRawHTML.substring( nRTItemsOpen + strRTItemsOpen.length, nRTItemsClose);
	if( strItems.length < 1 )
		return strRawHTML;
	
	// to reconstruct the item(s) param tag(s)
	var strItemsArray = strItems.split('$$**$$');
	if( strItemsArray.length < 1 )
		return strRawHTML;
	var strRunTimeItemParam = "";
	for( var i = 0; i < strItemsArray.length; i++ )
	{
		strRunTimeItemParam += '<PARAM  NAME="Item' + (i+1);
		strRunTimeItemParam += '"' + '  VALUE="';
		strRunTimeItemParam += strItemsArray[i];
		strRunTimeItemParam += '">';
	}
	
	// to insert the reconstructed item params into runtime object tag
	var strAdjustedHTML = strRawHTML.substring(0,nRTObjTagClose) + strRunTimeItemParam + strRawHTML.substring(nRTObjTagClose, strRawHTML.length);
	return kadovAdjustObjectTag(strAdjustedHTML, nDTCTagClose + strDTCTagClose.length);
}

function kadovTextPopupOnLoad( el )
{
	if( !CCSSP.bIsWinOS )
		return;

	if( typeof(el) == "string" )
		el = document.all.item(el);

	var src = el.getAttribute( "x-use-popup" );
	if(!src)
		return;

	var name = src;
	if( src.substr(0,1) == "#" ) 
		name = src.substr(1, src.length-1);
	var srcDiv = document.all.item(name);
	if( !srcDiv )
		return 1;

	var type = el.getAttribute( "x-popup-type" );
	var setup = el.getAttribute( "x-tmp-setup" );
	var newId = name;
	if( newId.indexOf( "_tmp") <= 0 )
		newId += "_tmp";

	if( !setup )
	{
		el.setAttribute( "x-tmp-setup", 1 );
	
		if( type == "pulldown"  )
		{
			var strAdjust = kadovAdjustObjectTag(srcDiv.innerHTML,0);
			var strCleanHTML = kadovRetrieveCleanHTML(strAdjust, "<!--", "-->");
			strCleanHTML = kadovRetrieveCleanHTML(strCleanHTML, "<SCRIPT", "/SCRIPT>");

			//work around the bug in HH.exe that highlight the phrases when use Search tab
			//this approach is just removing the <FONT...> tag inserted by Microsoft in the runtime
			strCleanHTML = kadovRetrieveCleanHTML(strCleanHTML, "<FONT color=#", "\">", 52);
			
			var strStyle = " style='display:none; position:relative;";
			var newDiv = "<div class=droptext id=" + newId + strStyle + "'>" + strCleanHTML + "</div>";

			srcDiv.outerHTML = ""; // empty the original DIV tag
			var elParentPra = kadovFindParentParagraph(el);
			if( elParentPra )
				elParentPra.insertAdjacentHTML( "AfterEnd", newDiv );
		}
		else if( type == "expanding"  )
		{
			var inner = kadovRetrieveTextInner(srcDiv);
			if( inner == "" )
				inner = srcDiv.innerHTML;
			var strAdjust = kadovAdjustObjectTag(inner,0);
			var strCleanHTML = kadovRetrieveCleanHTML(strAdjust, "<!--", "-->");
			strCleanHTML = kadovRetrieveCleanHTML(strCleanHTML, "<SCRIPT", "/SCRIPT>");
			var strClassName = (el.className == "glossterm") ? "glosstext" : "expandtext";
			var newSpan = "<span class=" + strClassName + " style='display: none;' id=" + newId + ">&nbsp;" + strCleanHTML + "</span>";
			srcDiv.outerHTML = ""; // empty the original DIV tag
			el.insertAdjacentHTML( "AfterEnd", newSpan );
		}
	}
}

function kadovTextPopup( el )
{
	if( (!CCSSP.bIsWinOS) || (window.event == null) )
		return;
	window.event.cancelBubble = true;

	if( typeof(el) == "string" )
		el = document.all.item(el);

	var src = el.getAttribute( "x-use-popup" );
	if(!src)
		return 1;

	var name = src;
	if( src.substr(0,1) == "#" ) 
		name = src.substr(1, src.length-1) + "_tmp";
	var srcDiv = document.all.item(name);
	if( !srcDiv )
		return 1;

	var type = el.getAttribute( "x-popup-type" );
	var setup = el.getAttribute( "x-tmp-setup" );
	if( srcDiv )
	{
		if( srcDiv.style.display == "" )
			srcDiv.style.display = "none";
		else
		{
			srcDiv.style.display = "";
			if( typeof(srcDiv.bInitialized) == "undefined" )
			{
				srcDiv.bInitialized = true;
				kadovInitEffects(name);
				kadovInitEachChild(srcDiv);
			}
		}
	}
}

function kadovFindParentParagraph( el )
{
	if( typeof(el) == "string" )
		el = document.all.item(el);
	if( (!el) || el.tagName == "BODY" )
		return null;
	if( kadovIsParagraph(el.parentElement) )
		return el.parentElement;
	else
		return kadovFindParentParagraph( el.parentElement );
}

//Begin HTML code invoked function
function kadovRegisterEventHandler( obj, strEvent, strEventHandler )
{
	if( !gbBsIE4 )
		return;
	CCSSP.RegisterEventHandler( obj, strEvent, strEventHandler );
}

function kadovTextPopupInit( el )
{
	if( (!gbBsIE4) || (!CCSSP.bIsWinOS) )
		return;
		
	if( typeof(el) == "string" )
		el = document.all.item(el);
	if( el != null )
	{
		CCSSP.RegisterEventHandler( el, "onclick", "kadovTextPopup(" + el.id +");" );
		CCSSP.RegisterEventHandler( window, "onload", "kadovTextPopupOnLoad(" + el.id +");" );
	}
}
//End HTML code invoked function

//End to support extended and dropdown text effects.

//Begin to convert iWrite format to RoboEditor Format for DHTML effects
function kadovInitTriggersInHead( )
{
  if( Object.xDelayedInitElements )
  {
     var x = Object.xDelayedInitElements;
     for(i=0; i<x.length; i++)
     	kadovInitTrigger( x[i] );
  }
}

//Begin HTML code invoked function
function kadovFilePopupInit( el )
{
	if( !gbBsIE4 )
		return;
	if( typeof(el) == "string" )
		el = document.all.item(el);

	if( el != null )
		CCSSP.RegisterEventHandler( el, "onmouseover", "BSPSPopupOnMouseOver(event);" );
}

function kadovInitTrigger( element )
{
	if( !gbBsIE4 )
		return;
	var srcElement = element;
	if( typeof(srcElement) == "string" )
	{
		srcElement = document.all.item(element,0);
		if(srcElement == null)
			return;
	}
	
	if( !kadovIsParentVisible(srcElement) )
		return;

	var targets = srcElement.getAttribute( "x-targets" );
	var arrOneTarget = targets.split( "," );
	for( var i = 0; i < arrOneTarget.length; i ++ )
		bsscFXInit( element, arrOneTarget[i], null, null, null, null );
}

function kadovIsParentVisible( el )
{
	if( typeof(el) == "string" )
		el = document.all.item(el);
	if( (!el) || el.tagName == "BODY" )
		return true;
	if( el.style.display == 'none' ) //el.visibility == 'hidden' || 
		return false;
	else
		return kadovIsParentVisible( el.parentElement );
}

function kadovInitEffects( element )
{
	if( !gbBsIE4 )
		return;
	var srcElement = element;
	if( typeof(srcElement) == "string" )
	{
		srcElement = document.all.item(element,0);
		if(srcElement == null)
			return;
	}
	
	if( !kadovIsParentVisible(srcElement) )
		return;
	
	kadovInitEffect( srcElement, "x-on-hover" );
	kadovInitEffect( srcElement, "x-on-pageclick" );
	kadovInitEffect( srcElement, "x-on-pageload" );
	kadovInitEffect( srcElement, "x-on-trigger-1" );
	kadovInitEffect( srcElement, "x-on-trigger-2" );
}
//End HTML code invoked function

function kadovInitEffect( element, prop )
{
	var values = null;
	if( element.getAttribute( "currentStyle" ) )
		values = element.currentStyle.getAttribute( prop );
	else 
		values = element.style.getAttribute( prop );
	if( !values )
		return;

	var functions = new Array();
	var nIdx = 0, nStart = 0;
	var nNext = values.indexOf( "\)", 0);
	while( nNext >= 0 && nNext < values.length )
	{
		functions[nIdx] = values.substr( nStart, nNext-nStart+1);
		nStart = nNext + 1;
		nIdx++;
		nNext = values.indexOf( "\)", nStart);
	}
		
	for( var i=0; i<functions.length; i++)
	{
		var id = element.getAttribute( "id" );
		var translatedProp = kadovTranslateProp(prop);

		var lp = functions[i].indexOf( "(" );
		var fnname = functions[i].substring(0, lp);
		var srcargs = functions[i].substring(lp+1, functions[i].length-1);
		
		var nClickTimes = 1;
		var arrForClickCount = srcargs.split( "," );
		for( var j = 0; j < arrForClickCount.length; j++ )
		{// to locate and get the "clicks=99" settings
			var nPageClick = arrForClickCount[j].indexOf("clicks");
			if( nPageClick >= 0 )
			{
				nPageClick = arrForClickCount[j].indexOf("=");
				if( nPageClick > 0 )
				{
					nClickTimes = arrForClickCount[j].substring( nPageClick + 1, arrForClickCount[j].length) * 1;
					break;
				}
			}
		}
		var args = srcargs;
		if( j < arrForClickCount.length )
		{// to strip out the "clicks=99" from the arguments string
			args = "";
			for( var k = 0; k < arrForClickCount.length; k ++ )
			{
				if( k != j )
				{
					args += arrForClickCount[k];
					if( k < arrForClickCount.length - 1 )
						args += ",";
				}
			}
		}
		bsscFXInit( null, id, translatedProp, fnname, args, nClickTimes );
	}
}

function kadovTranslateProp( prop )
{
	switch( prop )
	{
	case "x-on-hover" :     return "bsschover";
	case "x-on-pageclick" : return "bsscpageclick";
	case "x-on-pageload" :  return "bsscpageload";
	case "x-on-trigger-1" : return "bssctrigger1";
	case "x-on-trigger-2" : return "bssctrigger2";
	}
	return null;
}
//End to convert iWrite format to RoboEditor Format for DHTML effects

//Begin the definition of one entry to DHTML effects
function bsscFXInit( trigger_ID, target_ID, event_type, 
	action_type, action_setting, event_addional )
{
	if( !CCSSP.bIsWinOS || typeof(target_ID) != "string" )//MUST have a target_ID
		return; // we don't support Navigator yet
	
	if( typeof(event_type) == "string" )
		event_type = event_type.toLowerCase();
	if( typeof(action_type) == "string" )
		action_type = action_type.toLowerCase();
	if( typeof(action_setting) == "string" )
		 action_setting = action_setting.toLowerCase();
	
	// to get the target element then add it to the target list
	var eleTarget = CCSSP.GetObject( target_ID );
	if( (eleTarget != null) && (event_type != null) && (action_type != null) )
	{
		CEngine.AddOneTarget( target_ID, eleTarget );
		CEngine.BuildTargetObject(target_ID, event_type, action_type, action_setting, event_addional);
	}
	
	// to validate the trigger_ID parameter
	if( typeof(trigger_ID) == "string" && trigger_ID != "" )
		CEngine.BuildTriggerObject( trigger_ID, target_ID );
}	
//End the definition of one entry to DHTML effects


/// Section End  - kadov DHTM (JavaScript 1.2)


